<?= $this->include('layout/header_admin') ?>

<div class="container mt-4">
    <div class="card shadow">
        <div class="card-header bg-warning">
            <h5 class="mb-0">✏️ Edit Riwayat Pendidikan</h5>
        </div>

        <div class="card-body">
            <form action="/auth/pendidikan/update/<?= $pendidikan['id'] ?>"
                method="post"
                enctype="multipart/form-data">

                <!-- Logo Sekolah -->
                <div class="mb-3">
                    <label class="form-label">Logo Sekolah</label>
                    <input type="file" name="logo_sekolah"
                        class="form-control"
                        accept="image/*">
                </div>

                <?php if (!empty($pendidikan['logo_sekolah'])) : ?>
                    <div class="mb-3">
                        <label class="form-label">Logo Saat Ini</label><br>
                        <img src="/uploads/pendidikan/<?= $pendidikan['logo_sekolah'] ?>"
                            class="img-thumbnail"
                            width="120">
                    </div>
                <?php endif ?>

                <!-- Jenjang -->
                <div class="mb-3">
                    <label class="form-label">Jenjang</label>
                    <select name="jenjang" class="form-select" required>
                        <?php
                        $jenjang = ['SD', 'SMP', 'SMA', 'Kuliah'];
                        foreach ($jenjang as $j):
                        ?>
                            <option value="<?= $j ?>"
                                <?= $pendidikan['jenjang'] == $j ? 'selected' : '' ?>>
                                <?= $j ?>
                            </option>
                        <?php endforeach ?>
                    </select>
                </div>

                <!-- Nama Sekolah -->
                <div class="mb-3">
                    <label class="form-label">Nama Sekolah</label>
                    <input type="text" name="nama_sekolah"
                        class="form-control"
                        value="<?= esc($pendidikan['nama_sekolah']) ?>"
                        required>
                </div>

                <!-- Jurusan -->
                <div class="mb-3">
                    <label class="form-label">Jurusan</label>
                    <input type="text" name="jurusan"
                        class="form-control"
                        value="<?= esc($pendidikan['jurusan']) ?>">
                </div>

                <!-- Tahun Masuk -->
                <div class="mb-3">
                    <label class="form-label">Tahun Masuk</label>
                    <input type="number" name="tahun_masuk"
                        class="form-control"
                        value="<?= esc($pendidikan['tahun_masuk']) ?>">
                </div>

                <!-- Tahun Lulus -->
                <div class="mb-3">
                    <label class="form-label">Tahun Lulus</label>
                    <input type="number" name="tahun_lulus"
                        class="form-control"
                        value="<?= esc($pendidikan['tahun_lulus']) ?>">
                </div>

                <!-- Tombol -->
                <div class="d-flex justify-content-between">
                    <a href="/auth/pendidikan" class="btn btn-secondary">
                        ⬅️ Kembali
                    </a>
                    <button class="btn btn-success">
                        💾 Update
                    </button>
                </div>

            </form>
        </div>
    </div>
</div>
<?= $this->include('layout/footer_admin') ?>